<?php

/*
Plugin Name: Crumina Slider WP
Description: Crumina Slider
Author: Crumina
*/


$GLOBALS['CruminaPath'] = plugins_url('/', __FILE__);

// Activation hook for creating the initial DB table
register_activation_hook(__FILE__, 'crumina_slider_activation_scripts');

// Run activation scripts when adding new sites to a multisite installation
add_action('wpmu_new_blog', 'crumina_slider_new_site');

// Register custom settings menu
add_action('admin_menu', 'crumina_slider_settings_menu');

// Link content resources
//add_action('wp_enqueue_scripts', 'crumina_slider_enqueue_content_res');

add_action('wp_head', 'crumina_slider_enqueue_content_res');

// Link admin resources
add_action('admin_enqueue_scripts', 'crumina_slider_enqueue_admin_res');

// Add shortcode
add_shortcode("cruminaslider", "crumina_slider_init");

// Remove slider
if (isset($_GET['page']) && $_GET['page'] == 'crumina_slider' && isset($_GET['action']) && $_GET['action'] == 'remove') {
    add_action('admin_init', 'crumina_slider_removeslider');
}

function crumina_slider_activation_scripts()
{
    crumina_slider_create_db_table();
}


/********************************************************/
/*            crumina_slider new site activation           */
/********************************************************/

function crumina_slider_new_site($blog_id)
{

    // Get WPDB Object
    global $wpdb;

    // Get current site
    $old_site = $wpdb->blogid;

    // Switch to new site
    switch_to_blog($blog_id);

    // Run activation scripts
    crumina_slider_create_db_table();

    // Switch back the old site
    switch_to_blog($old_site);

}

function crumina_slider_create_db_table()
{

    global $wpdb;

    $table_name = $wpdb->prefix . "crumina_slider";

    $sql = "CREATE TABLE IF NOT EXISTS `$table_name` (
			  `id` int(10) NOT NULL AUTO_INCREMENT,
			  `name` varchar(100) NOT NULL,
			  `data` text NOT NULL,
			  `date_c` int(10) NOT NULL,
			  `date_m` int(11) NOT NULL,
			  PRIMARY KEY (`id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

    dbDelta($sql);
}


function crumina_slider_enqueue_content_res()
{
    wp_enqueue_script('crumina_slider_content_js', $GLOBALS['CruminaPath'] . 'js/crumina_slider_content.js', array('jquery'), '3.6.2');
    wp_enqueue_style('crumina_slider_css', $GLOBALS['CruminaPath'] . 'css/crumina_slider.css', array(), '3.6.2');
}


/********************************************************/
/*                Enqueue Admin Scripts                 */
/********************************************************/

function crumina_slider_enqueue_admin_res()
{

    if (strstr($_SERVER['REQUEST_URI'], 'crumina_slider')) {

         // New in 3.5
        if (function_exists('wp_enqueue_media')) {
            wp_enqueue_media();
        }

        wp_enqueue_script('thickbox');
        wp_enqueue_style('thickbox');

        wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_script( 'wp-color-picker' );


        wp_enqueue_style('crumina_slider_admin_css', $GLOBALS['CruminaPath'] . 'css/admin.css', array(), '3.6.2');

        wp_enqueue_script('crumina_slider_misc', $GLOBALS['CruminaPath'] . 'js/crumina_slider.js', array('jquery'), '3.6.2');

    }
}


function crumina_slider_settings_menu()
{

    global $crumina_slider_hook;

    $crumina_slider_hook = add_menu_page('Crumina Slider', 'Crumina Slider', 'manage_options', 'crumina_slider', 'crumina_slider_router');

    add_submenu_page('crumina_slider', 'CruminaSlider WP', __('All Sliders', 'Crumina Slider'), 'manage_options', 'crumina_slider', 'crumina_slider_router');
    add_submenu_page('crumina_slider', 'Add New Slider', __('Add New', 'Crumina Slider'), 'manage_options', 'crumina_slider_add_new', 'crumina_slider_add_new');

    add_action('admin_init', 'crumina_slider_register_settings');
}

function crumina_slider_router()
{


    if (isset($_GET['action']) && $_GET['action'] == 'add') {
        include(dirname(__FILE__) . '/add.php');

    } elseif (isset($_GET['action']) && $_GET['action'] == 'edit') {
        include(dirname(__FILE__) . '/edit.php');

    } elseif (isset($_GET['action']) && $_GET['action'] == 'get_posts') {
        include(dirname(__FILE__) . '/ajax/get_posts.php');

        $post_type_name = (isset($_GET['crumina_post_type'])) ? $_GET['crumina_post_type'] : '';

        echo crumina_slider_get_posts($post_type_name);
        die();
    } else {
        include(dirname(__FILE__) . '/list.php');
    }
}

function crumina_slider_add_new()
{
    include(dirname(__FILE__) . '/add.php');
}

function crumina_slider_register_settings()
{

    // Add slider
    if (isset($_POST['posted_add']) && strstr($_SERVER['REQUEST_URI'], 'crumina_slider')) {

        // Get WPDB Object
        global $wpdb;

        $slider_data = json_encode($_POST['slider']);
        $slider_title = (isset($_POST['title'])) ? $_POST['title'] : '';


        // Table name
        $table_name = $wpdb->prefix . "crumina_slider";

        // Create new record
        if ($_POST['layerkey'] == 0) {


            // Execute query
            $wpdb->query(
                $wpdb->prepare("INSERT INTO $table_name
									(name, data, date_c, date_m)
								VALUES (%s, %s, %d, %d)",
                    "$slider_title",
                    "$slider_data",
                    time(),
                    time()
                )
            );


            // Empty slider
            $slider = array();

            // ID
            $id = mysql_insert_id();
        }

        header('Location: admin.php?page=crumina_slider');
        die();
    }

    // Edit slider
    if (isset($_POST['posted_edit']) && strstr($_SERVER['REQUEST_URI'], 'crumina_slider')) {

        // Get WPDB Object
        global $wpdb;

        // Table name
        $table_name = $wpdb->prefix . "crumina_slider";

        // Get the IF of the slider
        $id = (int)$_GET['id'];

        $slider = array();

        $slider = $_POST['slider'];
        $title = (isset($_POST['title'])) ? $_POST['title'] : '';

        // DB data
        $name = $wpdb->escape($title);
        $data = $wpdb->escape(json_encode($slider));

        // Update
        $wpdb->query("UPDATE $table_name SET
					name = '$name',
					data = '$data',
					date_m = '" . time() . "'
				  WHERE id = '$id' LIMIT 1");

        // Redirect back
        header('Location: admin.php?page=crumina_slider');
        die();
    }

}


function crumina_slider_removeslider()
{

    if (!isset($_GET['id'])) {
        return;
    }

    $id = (int)$_GET['id'];

    global $wpdb;

    $table_name = $wpdb->prefix . "crumina_slider";

    $wpdb->query("DELETE FROM $table_name WHERE id = '$id' LIMIT 1");

    header('Location: admin.php?page=crumina_slider');
    die();
}

function hex2rgb($hex)
{
    $hex = str_replace("#", "", $hex);

    if (strlen($hex) == 3) {
        $r = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
        $g = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
        $b = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
    } else {
        $r = hexdec(substr($hex, 0, 2));
        $g = hexdec(substr($hex, 2, 2));
        $b = hexdec(substr($hex, 4, 2));
    }
    $rgb = array($r, $g, $b);
    return implode(",", $rgb);
    //return $rgb; // returns an array with the rgb values
}

function html2text($html)
{
    $text = $html;
    static $search = array(
        '@<script.+?</script>@usi', // Strip out javascript content
        '@<style.+?</style>@usi', // Strip style content
        '@<!--.+?-->@us', // Strip multi-line comments including CDATA
        '@</?[a-z].*?\>@usi', // Strip out HTML tags
    );
    $text = preg_replace($search, ' ', $text);
    // normalize common entities
    //$text = normalizeEntities($text);
    // decode other entities
    $text = html_entity_decode($text, ENT_QUOTES, 'utf-8');
    // normalize possibly repeated newlines, tabs, spaces to spaces
    $text = preg_replace('/\s+/u', ' ', $text);
    $text = trim($text);
    // we must still run htmlentities on anything that comes out!
    // for instance:
    // <<a>script>alert('XSS')//<<a>/script>
    // will become
    // <script>alert('XSS')//</script>
    return $text;
}


function crumina_slider_init($atts, $content = null)
{
    extract(shortcode_atts(array(
        "id" => ''
    ), $atts));

    global $wpdb;

    $table_name = $wpdb->prefix . "crumina_slider";
    $slider     = $wpdb->get_results("SELECT
										*
									  FROM $table_name
									  WHERE id = $id");
    if (!empty($slider)) :

        $slider_data = array();
        $slider     = current($slider);

        $sl_id       = sanitize_title($slider->id . $slider->name);
        $slider_data = json_decode($slider->data, true);

        $sl_sort = $slider_data['sort'];
        $sl_sort_order = $slider_data['sort_order'];
        $sl_separator = (isset($slider_data['separator']) && !empty($slider_data['separator'])) ? $slider_data['separator'] : '';
        $sl_opacity = (isset($slider_data['opacity']) && !empty($slider_data['opacity'])) ? $slider_data['opacity'] : 80;
        $sl_timeout = $slider_data['timeout'];
        $sl_effect = $slider_data['effect'];
        $sl_posts = $slider_data['post_type'];
        $sl_posts_num = $slider_data['posts'];
        $sl_chars_limit = (!empty($slider_data['chars_limit'])) ? $slider_data['chars_limit'] : 0;
        $sl_backgr_color = $slider_data['backgr_color'];
        $sl_button_color = $slider_data['button_color'];
        $sl_button_color_active = $slider_data['button_color_active'];
        $show_date = (isset($slider_data['show_date'])) ? true : false;
        $sl_auto_mode  = (isset($slider_data['auto_mode'])) ? 'true' : 'false';
        $sl_auto_speed = (isset($slider_data['auto_mode_speed'])) ? $slider_data['auto_mode_speed'] : '';

        $sl_html = '';


        if (!empty($sl_backgr_color)) {
            $b_color = hex2rgb($sl_backgr_color);
        } else {
            $b_color = '87,186,232';
        }


        if (preg_match('/MSIE/i', $_SERVER['HTTP_USER_AGENT'])) {
            $item_bg = ' #'.$sl_id.' .item .description
		{
			background: ' . $sl_backgr_color . ';
		}';

        }
        else
        {
            if (!empty($sl_opacity)) {
                $item_bg = 'background: rgba('.$b_color.',.' . $sl_opacity . ')';
            }
        }


        if (is_array($sl_posts)) {

            $pst = implode(', ', $sl_posts);

            $args = array('include'   => "$pst",
                'post_type' => 'any',
                'orderby'   => "$sl_sort",
                'order'     => $sl_sort_order);

            $post_data = get_posts($args);

            $count = 1;

            foreach ($post_data as $post) {

                $post_content = $additional_css = $img_style = $date_content = $descr_class = '';

                $post_desc_option = get_post_meta($post->ID, 'post_description_display', true);

                if(empty($post_desc_option)) $post_desc_option = 'full';

                if ($post_desc_option == 'show') {
                    $post_description = $post->post_title;
                } elseif ($post_desc_option == 'hide') {
                    $post_description = '';
                } elseif ($post_desc_option == 'full') {

                    if($sl_posts_num == 1)
                        $descr_class = 'slider_description_one';
                    else
                        $descr_class = 'slider_description';

                    if ($post->post_excerpt) {
                        $post_description = $post->post_title . '<p><p class="' . $descr_class . '">' . html2text(strip_shortcodes($post->post_excerpt));
                    }
                    else {
                        $post_description = $post->post_title . '<p><p class="' . $descr_class . '">' . html2text(strip_shortcodes($post->post_content));
                    }
                }

                if (!empty($post_description)) {

                    if (strlen($post_description) > $sl_chars_limit) {

						$short = substr($post_description, 0, $sl_chars_limit);
						$short = explode(' ', $short);
						array_pop($short);
						$short = implode(' ', $short);


                        $content = $short . ' ' . $sl_separator;

                    } else {
                        $content = $post_description;
                    }

                    if ($show_date) {

                        $post_content = '<div class="title">' . $content . '</div>';

                        $date_content = '<span class="date">' . strftime("%c", strtotime($post->post_date)) . '</span>';
                    }
                    else {
                        $post_content = '<div class="title no-date">' . $content . '</div>';
                    }

                }

                $date_img = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'large');

                if (!empty($date_img))
                {
                    $img_src = $date_img[0];

                    if ($sl_posts_num == 1)
                    {
                        $img_src = aq_resize($img_src, 750, 300, true); //resize & crop img
                        $img_style = "style='width:100%;'";
                    }
                    else
                    {
                        $img_src = aq_resize($img_src, 584, 240, true); //resize & crop img
                    }



                    $data_img_html = '<img src="' . $img_src . '" ' . $img_style . ' class = "slider_zoom" alt="">';
                }
                else
                {
                    $img_src = get_template_directory() . '/assets/images/no-image-blog-one.jpg';


                    if ($sl_posts_num == 1)
                    {
                        $thumbpath = get_template_directory() . '/assets/images/';

                        $width_img  = 750;
                        $height_img = 300;

                        resize_image( $img_src, $width_img, $height_img, false, $thumbpath. 'no_image_resized_' . $width_img . '-' . $height_img . '.jpg', false);

                        $img_src = get_template_directory_uri() . '/assets/images/no_image_resized_' . $width_img . '-' . $height_img . '.jpg';

                        $img_style = "style='width:100%;'";
                    }
                    else
                    {

                        $thumbpath = get_template_directory() . '/assets/images/';

                        $width_img  = 584;
                        $height_img = 240;

                        resize_image( $img_src, $width_img, $height_img, false, $thumbpath. 'no_image_resized_' . $width_img . '-' . $height_img . '.jpg' , false);

                        $img_src = get_template_directory_uri() . '/assets/images/no_image_resized_' . $width_img . '-' . $height_img . '.jpg';

                    }

                    $data_img_html = '<img src="' . $img_src . '" ' . $img_style . ' alt="" />';
                }

                $width = ($sl_posts_num == 1) ? ' sin-sl-img" style="width:99%;"' : '"';

                if ($post_desc_option != 'hide') {
                    $desciption = '
                <div class="description disp" style="'.$item_bg.'">
                    <div class="icon">
                        <img src="' . get_bloginfo('stylesheet_directory') . '/assets/images/folio-mini-image.png"  alt="">
                    </div>
                    <div class="info">
                        ' . $date_content . '
                    </div>
                    ' . $post_content . '
                </div>
                ';
                }

                $html_post = '
                <div class="item ' . $width . '>
                    ' . $data_img_html . $desciption . '
                    <a class="more" href="' . get_permalink($post->ID) . '"></a>
                </div>';

                if ($sl_posts_num == 1) {
                    $sl_html .= '<div class="crumina-slides">';
                    $sl_html .= $html_post;
                    $sl_html .= "</div>";

                } else {
                    if ($count % $sl_posts_num == 1) {
                        $sl_html .= '<div class="crumina-slides">';
                    }

                    $sl_html .= $html_post;

                    if ($count % $sl_posts_num == 0) {
                        $sl_html .= "</div>";
                    }
                }

                $count++;
            }

            if ($count % $sl_posts_num != 1 && $sl_posts_num != 1) $sl_html .= "</div>";

        }

        $css_code = '';

        if (!empty($sl_button_color)) {
            $css_code = ' #'.$sl_id.' .slider-nav a
		{
			background: ' . $sl_button_color . '
		}';
        }

        if (!empty($sl_button_color_active)) {
            $css_code .= ' #'.$sl_id.' .slider-nav a:hover
		{
			background: ' . $sl_button_color_active . '
		}';
        }




        $sl_timeout   = (empty($sl_timeout)) ? 500 : $sl_timeout;
        $sl_effect    = (empty($sl_effect)) ? 'horizontal-push' : $sl_effect;
        $sl_auto_speed    = (empty($sl_auto_speed)) ? 2000 : $sl_auto_speed;

        return '
    <div class="main-slider-block">

        <div class="clearing-container slider-wrap" id="' . $sl_id . '" >' . $sl_html . '</div>

        <div class="slider-nav"></div>

	</div>

     <script type="text/javascript">
        jQuery(function() {
            jQuery("#'.$sl_id.'").crumina_slider({
            animation: "' . $sl_effect . '",
            animationSpeed: ' . $sl_timeout . ',
            timer: ' . $sl_auto_mode . ',
            timer_speed : ' . $sl_auto_speed .  '
        })
        });

    </script>
    <style>'.$css_code.'</style>

';


    endif;
}

function resize_image( $file, $width = 0, $height = 0, $proportional = false, $output = 'file', $delete_original = true )
{
    if ( $height <= 0 && $width <= 0 ) return false;

    $info = getimagesize($file);
    $image = '';

    $final_width = 0;
    $final_height = 0;
    list($width_old, $height_old) = $info;

    if ($proportional) {
        if ($width == 0) $factor = $height/$height_old;
        elseif ($height == 0) $factor = $width/$width_old;
        else $factor = min ( $width / $width_old, $height / $height_old);

        $final_width = round ($width_old * $factor);
        $final_height = round ($height_old * $factor);
    } else {
        $final_width = ( $width <= 0 ) ? $width_old : $width;
        $final_height = ( $height <= 0 ) ? $height_old : $height;
    }

    switch ($info[2]) {
        case IMAGETYPE_GIF:
            $image = imagecreatefromgif($file);
            break;
        case IMAGETYPE_JPEG:
            $image = imagecreatefromjpeg($file);
            break;
        case IMAGETYPE_PNG:
            $image = imagecreatefrompng($file);
            break;
        default:
            return false;
    }

    $image_resized = imagecreatetruecolor( $final_width, $final_height );

    if(($info[2] == IMAGETYPE_GIF) || ($info[2] == IMAGETYPE_PNG)) {
        $trnprt_indx = imagecolortransparent($image);

        // If we have a specific transparent color
        if($trnprt_indx >= 0) {

            // Get the original image's transparent color's RGB values
            $trnprt_color    = imagecolorsforindex($image, $trnprt_indx);

            // Allocate the same color in the new image resource
            $trnprt_indx    = imagecolorallocate($image_resized, $trnprt_color['red'], $trnprt_color['green'], $trnprt_color['blue']);

            // Completely fill the background of the new image with allocated color.
            imagefill($image_resized, 0, 0, $trnprt_indx);

            // Set the background color for new image to transparent
            imagecolortransparent($image_resized, $trnprt_indx);


        }
        // Always make a transparent background color for PNGs that don't have one allocated already
        elseif ($info[2] == IMAGETYPE_PNG) {

            // Turn off transparency blending (temporarily)
            imagealphablending($image_resized, false);

            // Create a new transparent color for image
            $color = imagecolorallocatealpha($image_resized, 0, 0, 0, 127);

            // Completely fill the background of the new image with allocated color.
            imagefill($image_resized, 0, 0, $color);

            // Restore transparency blending
            imagesavealpha($image_resized, true);
        }
    }

    imagecopyresampled($image_resized, $image, 0, 0, 0, 0, $final_width, $final_height, $width_old, $height_old);

    if($delete_original) @unlink($file);

    switch (strtolower($output)) {
        case 'browser':
            $mime = image_type_to_mime_type($info[2]);
            header("Content-type: $mime");
            $output = NULL;
            break;
        case 'file':
            $output = $file;
            break;
        case 'return':
            return $image_resized;
            break;
        default:
            break;
    }

    switch ($info[2]) {
        case IMAGETYPE_GIF:
            imagegif($image_resized, $output);
            break;
        case IMAGETYPE_JPEG:
            imagejpeg($image_resized, $output);
            break;
        case IMAGETYPE_PNG:
            imagepng($image_resized, $output);
            break;
        default:
            return false;
    }

    return true;
}