<?php

// Get WPDB Object
global $wpdb;

$args=array(
'public'   => true,
'_builtin' => false
);

$post_types=get_post_types($args);

$table_name = $wpdb->prefix . "crumina_slider";

$id = (int) $_GET['id'];

$slider_db = $wpdb->get_row("SELECT * FROM $table_name WHERE id = ".(int)$id." ORDER BY date_c DESC LIMIT 1" , ARRAY_A);
$slider = json_decode($slider_db['data'], true);
?>
<form action="<?php echo $_SERVER['REQUEST_URI']?>" method="post" class="wrap" id="ls-slider-form">

	<input type="hidden" name="posted_edit" value="1">

	<h2>
		<?php _e('Edit this Slider', 'crum') ?>
		<a href="?page=crumina_slider" class="add-new-h2"><?php _e('Back to the list', 'crum') ?></a>
	</h2>


	<div id="ls-pages">

		<!-- Global Settings -->
		<div class="ls-page ls-settings active">

			<div id="post-body-content">
				<div id="titlediv">
					<div id="titlewrap">
						<input type="text" name="title" value="<?php echo $slider_db['name'] ?>" id="title" autocomplete="off" placeholder="<?php _e('Type your slider name here', 'crum') ?>">
					</div>
				</div>
			</div>

            <div class="ls-box ls-settings" id="hor-zebra">
			
				<table>
					<thead>
						<tr>
							<td colspan="3">

								<h4><?php _e('Slider settings', 'crum') ?></h4>
							</td>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td><?php _e('Choose Sorting of Posts/Pages', 'crum') ?></td>
							<td>
							<select name="slider[sort]">
							<option value='date' <?php if($slider['sort'] == 'date') echo 'selected'; ?>>Date</option>
							<option value='ID' <?php if($slider['sort'] == 'ID') echo 'selected'; ?>>Post ID</option>
							<option value='name' <?php if($slider['sort'] == 'name') echo 'selected'; ?>>Slug</option>
							<option value='title' <?php if($slider['sort'] == 'title') echo 'selected'; ?>>Title</option>
							<option value='author' <?php if($slider['sort'] == 'author') echo 'selected'; ?>>Author ID</option>
							</select>
							<td class="desc"></td>
						</tr>
						<tr>
							<td><?php _e('Number of Posts/Pages', 'crum') ?></td>
							<td>
							<select name="slider[posts]">
							<option value="1" <?php if($slider['posts'] == '1') echo 'selected'; ?>>1</option>
							<option value="2" <?php if($slider['posts'] == '2') echo 'selected'; ?>>2</option>
							<option value="4" <?php if($slider['posts'] == '4') echo 'selected'; ?>>4</option>
							<option value='8' <?php if($slider['posts'] == '8') echo 'selected'; ?>>8</option>
							<option value='12' <?php if($slider['posts'] == '12') echo 'selected'; ?>>12</option>
							</select>
							</td>
							<td class="desc"></td>
						</tr>
						<tr>
							<td><?php _e('Slider items from Posts/Pages', 'crum') ?></td>
							<td>
							<?php

							$all_post_types = (array('post','page','product','my-product'));

							echo '<select name="slider[post_type][]" multiple="multiple" style="width: 350px;height: 150px;">';
							
							foreach ($all_post_types as $sl_post_type_name)
							{
								//echo $post_type_name;
								$args = array('post_type' => $sl_post_type_name, 'numberposts' => '-1');
								$sl_post_type_items = get_posts($args);

								if(is_array($sl_post_type_items))
								{

									foreach($sl_post_type_items as $sl_post_type)
									{
										/*$args = array('post_type' => $post_type);
										$post_type_items = get_posts($args);

										foreach($post_type_items as $post_item)
										{*/
										if(is_array($slider['post_type']) && in_array($sl_post_type->ID, $slider['post_type'])) $selected = 'selected'; else $selected = '';
										echo '<option value="' . $sl_post_type->ID . '" ' . $selected . ' >' . ucfirst($sl_post_type->post_type) . ' - ' . $sl_post_type->post_title . '</option>';
										//}
                        ?>
                                <?php
									}

								}

							}
							echo '</select>';
                        ?>

                        	</td>
							<td class="desc"></td>
						</tr>
                        <tr>
							<td><?php _e('Choose Order of Posts/Pages', 'crum') ?></td>
							<td>
							<select name="slider[sort_order]">
							<option value='asc' <?php if($slider['sort_order'] == 'asc') echo 'selected'; ?>>ASC</option>
							<option value='desc' <?php if($slider['sort_order'] == 'desc') echo 'selected'; ?>>DESC</option>
							</select>
							
							</td>
							<td class="desc"></td>
						</tr>
                        <tr>
							<td><?php _e('Limit Description (Number of chars)', 'crum') ?></td>
							<td><input type="text" name="slider[chars_limit]" value="<?php echo $slider['chars_limit']; ?>" class="input"></td>
							<td class="desc"></td>
						</tr>
                        <tr>
							<td><?php _e('More Seperator', 'crum') ?></td>
							<td><input type="text" name="slider[separator]" value="<?php echo $slider['separator']; ?>" class="input"></td>
							<td class="desc"></td>
						</tr>
                        <tr>
                            <td><?php _e('Set Slider Effect', 'crum') ?></td>
                            <td>
                                <select name="slider[effect]" style="width: 200px;">
                                    <option value="horizontal-push" <?php if($slider['effect'] == 'horizontal-push') echo 'selected'; ?>>Horizontal Push</option>
                                    <option value="fade" <?php if($slider['effect'] == 'fade') echo 'selected'; ?>>Fade</option>
                                    <option value="horizontal-slide" <?php if($slider['effect'] == 'horizontal-slide') echo 'selected'; ?>>Horizontal</option>
                                </select>
                            </td>
                            <td class="desc"></td>
                        </tr>
                        <tr>
                            <td><?php _e('Set Slider Timeout (in ms)', 'crum') ?></td>
                            <td><input type="text" name="slider[timeout]" value="<?php echo $slider['timeout']; ?>" class="input"></td>
                            <td class="desc"></td>
                        </tr>
                        <tr>
                            <td><?php _e('Enable Auto Slider', 'crum') ?></td>
                            <td><input type="checkbox" name="slider[auto_mode]" <?php if(isset($slider['auto_mode'])) echo 'checked'; ?>></td>
                            <td class="desc"></td>
                        </tr>
                        <tr>
                            <td><?php _e('Auto Slider Speed (ms)', 'crum') ?></td>
                            <td><input type="text" name="slider[auto_mode_speed]" class="input" value="<?php if (empty($slider['auto_mode_speed'])) echo '2000'; else echo $slider['auto_mode_speed']; ?>"></td>
                            <td class="desc"></td>
                        </tr>
                        <tr>
							<td><?php _e('Set Background Color', 'crum') ?></td>
							<td><input type="text" id="background_color" name="slider[backgr_color]" value="<?php echo $slider['backgr_color']; ?>" class="input">
							<div id="color_picker_background_color"></div>
							</td>
							<td class="desc"></td>
						</tr>

                        <tr>
							<td><?php _e('Set Opacity (0 - 100)', 'crum') ?></td>
							<td><input type="text" name="slider[opacity]" value="<?php echo $slider['opacity']; ?>" class="input"></td>
							<td class="desc"></td>
						</tr>

                        <tr>
							<td><?php _e('Set Button Color', 'crum') ?></td>
							<td><input type="text" id="button_color" name="slider[button_color]" value="<?php echo $slider['button_color']; ?>" class="input">
							<div id="color_picker_button"></div>
							</td>
							<td class="desc"></td>
						</tr>

                        <tr>
							<td><?php _e('Set Active Button Color', 'crum') ?></td>
							<td><input type="text" id="active_button" name="slider[button_color_active]" value="<?php echo $slider['button_color_active']; ?>" class="input">
							<div id="color_picker_active_button"></div>
							</td>
							<td class="desc"></td>
						</tr>

						<tr>
							<td><?php _e('Show date', 'crum') ?></td>
							<td><input type="checkbox" name="slider[show_date]" <?php if(isset($slider['show_date'])) echo 'checked'; ?>></td>
							<td class="desc"></td>
						</tr>

					</tbody>


				</table>

			</div>
		</div>



		<!-- Event Callbacks -->

	</div>

			<button class="button-primary"><?php _e('Save changes', 'crum') ?></button>
			<p class="ls-saving-warning"></p>
			<div class="clear"></div>

</form>