<?php
	global $wpdb;
	$table_name = $wpdb->prefix . "crumina_slider";
	$sliders    = $wpdb->get_results( "SELECT * FROM $table_name ORDER BY date_c ASC" );
	
?>
<div class="wrap">

	<h2>
		<?php _e('Crumina sliders', 'crum') ?>
		<a href="?page=crumina_slider_add_new" class="add-new-h2"><?php _e('Add New', 'crum') ?></a>
	</h2>

	<div class="ls-box ls-slider-list">
		<table id="hor-zebra">
			<thead>
				<tr>
					<td>#</td>
					<td><?php _e('Name', 'crum') ?></td>
					<td><?php _e('Shortcode', 'crum') ?></td>
					<td><?php _e('Actions', 'crum') ?></td>
					<td><?php _e('Created', 'crum') ?></td>
					<td><?php _e('Modified', 'crum') ?></td>
				</tr>
			</thead>
			<tbody>
				<?php if(!empty($sliders)) : ?>
				<?php foreach($sliders as $key => $item) : ?>
				<?php $name = empty($item->name) ? 'Unnamed' : $item->name; ?>
				<tr>
					<td><?php echo ($key+1) ?></td>
					<td><a href="?page=crumina_slider&action=edit&id=<?php echo $item->id ?>"><?php echo $name ?></a></td>
					<td>[cruminaslider id="<?php echo $item->id ?>"]</td>
					<td>
						<a href="?page=crumina_slider&action=edit&id=<?php echo $item->id ?>"><?php _e('Edit', 'crum') ?></a> |
						<a href="?page=crumina_slider&action=remove&id=<?php echo $item->id ?>" class="remove">
						<?php _e('Remove', 'crum') ?></a>
					</td>
					<td><?php echo date('M - d - Y', $item->date_c) ?></td>
					<td><?php echo date('M - d - Y', $item->date_m) ?></td>
				</tr>
				<?php endforeach; ?>
				<?php endif; ?>
				<?php if(empty($sliders)) : ?>
				<tr>
					<td colspan="6"><?php _e("You didn't create any slider yet.", "crum") ?></td>
				</tr>
				<?php endif; ?>
			</tbody>
		</table>
	</div>
</div>