<?php
require('constant.php');
?>
<!DOCTYPE html>
<html lang="en">
<link href="css/mdb.css" rel="stylesheet">
<link href="css/font-awesome.css" rel="stylesheet">
<link href="style.css" type="text/css" rel="stylesheet" />

<head>
	<title>Synapse</title>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<script src="component/jquery/jquery-3.2.1.min.js"></script>

	<script>
	$(document).ready(function (e){
		$("#frmContact").on('submit',(function(e){
			e.preventDefault();
			$("#mail-status").hide();
			$('#send-message').hide();
			$('#loader-icon').show();
			$.ajax({
				url: "contact.php",
				type: "POST",
				dataType:'json',
				data: {
				"senderid":$('input[name="senderid"]').val(),
				"phone":$('input[name="phone"]').val(),
				"g-recaptcha-response":$('textarea[id="g-recaptcha-response"]').val()},				
				success: function(response){
				$("#mail-status").show();
				$('#loader-icon').hide();
				setTimeout(function(){
                location.reload();
                }, 3000);
				if(response.type == "error") {
					$('#send-message').show();
					$("#mail-status").attr("class","error");				
				} else if(response.type == "message"){
					$('#send-message').hide();
					$("#mail-status").attr("class","success");							
				}
				$("#mail-status").html(response.text);	
				},
				error: function(){} 
			});
		}));
	});
	</script>

	<style>
	.label {margin: 2px 0;}
	.field {margin: 0 0 20px 0;}	
		.content {width: 600px;margin: 0 auto; background:#ffffff; padding:20px;}
		h1, h2 {font-family:"Georgia", Times, serif;font-weight: normal;}
		div#central {margin: 40px 0px 100px 0px;}
		@media all and (min-width: 768px) and (max-width: 979px) {.content {width: 750px;}}
		@media all and (max-width: 767px) {
			body {margin: 0 auto;word-wrap:break-word}
			.content {width:auto;}
			div#central {	margin: 40px 20px 100px 20px;}
		}
		body {font-family: 'Helvetica',Arial,sans-serif;background:#ffffff;margin: 0 auto;-webkit-font-smoothing: antialiased;  font-size: initial;line-height: 1.7em;
		background-image:url(img/bg.jpg); background-size:cover; background-attachment:fixed;background-repeat: no-repeat; height:100%}	
		
		
		input, textarea {width:100%;padding: 15px;font-size:1em;border: 1px solid #A1A1A1;	}
		button {
			padding: 12px 60px;
			background: #5BC6FF;
			border: none;
			color: rgb(40, 40, 40);
			font-size:1em;
			font-family: "Georgia", Times, serif;
			cursor: pointer;	
		}
		#message {  padding: 0px 40px 0px 0px; }
		#mail-status {
			padding: 12px 20px;
			width: 100%;
			display:none; 
			font-size: 1em;
			font-family: "Georgia", Times, serif;
			color: rgb(40, 40, 40);
			margin-bottom: 20px;
		}
	  .error{background-color: #F7902D;  margin-bottom: 40px;}
	  .success{background-color: #48e0a4; }
		.g-recaptcha {margin: 0 0 25px 0;}	  
	</style>
	<script src='https://www.google.com/recaptcha/api.js'></script>	
</head>
<body>
<div  id="central" class="col-md-6 col-sm-6 mb-4 cnt" style="margin:0 auto;">
<div class="card">
<h5 class="card-header info-color white-text text-center py-4">
                   <div align="center"><strong>Optout of promotional SMS</strong></div>
                </h5>
				<div id="message" class="card-body px-lg-5">
				<form id="frmContact" action="" method="POST" novalidate="novalidate">
				
				<div class="md-form mt-3">
                            <input type="text" id="phone" name="phone" class="form-control" maxlength="12" placeholder="971445356247" autocomplete="off" required title="Mobile Number should only contain numbers e.g. 971445356247">
                            <label for="phone">Mobile Number <span class="text-danger">*</span> </label>
                        </div>
	<div class="md-form mt-3">
                            <input type="text" id="senderid" name="senderid" class="form-control" placeholder="VM999" maxlength="11" title="Sender ID should only contain alphanumeric & - e.g. Sender-& 45">
                            <label for="senderid">Sender ID </label>
                        </div>

			<div class="g-recaptcha" data-sitekey="<?php echo SITE_KEY; ?>"></div>			
			<div id="mail-status"></div>			
			<button id="send-message" class="btn btn-info btn my-4 waves-effect z-depth-0" type="submit">Submit</button>
		</form>
				
				</div>

</div>
</div>

	<script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.js"></script>
    <script src="js/mdb.js"></script>

</body>
</html>