//Registration form
$(document).ready(function(){
	$('#contact_form').validate(
    {
         rules: {
            name: {
                required: true,
                minlength: 3
            },
            email: {
                required: true,
                email: true
            },
            message: {
                required: true,
                minlength: 10
            }
         },
         errorClass: "help-inline",
         highlight: function(label) {
           $(label).closest('.form-group').addClass('has-error');
         },
         success: function(label) {			 
             $(label).closest('.form-group').removeClass('has-error').addClass('has-success');        
         },		
         submitHandler: function (form) {
				
				var url = "contact.php";
				
                $.ajax({
                type: "POST",
                url: url,
                data: $(form).serialize(),
                success: function (data)
                {
                    var messageAlert = 'alert-' + data.type;
                    var messageText = data.message;

                    var alertBox = '<div class="alert ' + messageAlert + ' alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' + messageText + '</div>';
                    if (messageAlert && messageText) {
                        $('#contact_form').find('.messages').html(alertBox);
                        $('#contact_form')[0].reset();
                    }
                }
            });
				return false;            
			
        }
    });				   
});