//Registration form
$(document).ready(function(){
	$('#registration_form').validate(
    {
         rules: {
            firstName: {
                required: true,
                minlength: 3
            },
            email: {
                required: true,
                email: true
            },
			phnumber: {                
                number: true,
				minlength: 5
            },
            password: {
                required: true,
                minlength: 6
            }
         },
         errorClass: "help-inline",
         highlight: function(label) {
           $(label).closest('.form-group').addClass('has-error');
         },
         success: function(label) {			 
             $(label).closest('.form-group').removeClass('has-error').addClass('has-success');        
        },
         submitHandler: function (form) {
            if ($("#registration_form").valid()) {
                //alert(base_url+"personal/");
                //form.submit();
				var url = "signup.php";
                $.ajax({
                type: "POST",
                url: url,
                data: $(this).serialize(),
                success: function (data)
                {
                    var messageAlert = 'alert-' + data.type;
                    var messageText = data.message;

                    var alertBox = '<div class="alert ' + messageAlert + ' alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' + messageText + '</div>';
                    if (messageAlert && messageText) {
                        $('#registration_form').find('.messages').html(alertBox);
                        $('#registration_form')[0].reset();
                    }
                }
            });
            }         
        }
    });				   
});