RewriteEngine on
RewriteCond %{HTTP_HOST} ^vectramind.com [NC]
RewriteCond %{REQUEST_URI} !^/\.well-known/acme-challenge/[0-9a-zA-Z_-]+$
RewriteCond %{REQUEST_URI} !^/\.well-known/cpanel-dcv/[0-9a-zA-Z_-]+$
RewriteCond %{REQUEST_URI} !^/\.well-known/pki-validation/[A-F0-9]{32}\.txt(?:\ Comodo\ DCV)?$
RewriteRule ^(.*)$ http://www.vectramind.com/$1 [L,R=301,NC]
Redirect 301 /contact-us.html /contactus.html
Redirect 301 /ecard/ /ecard/index.html
Redirect 301 /services/index.html /services.html

## EXPIRES CACHING ##
<IfModule mod_expires.c>
ExpiresActive On
ExpiresByType image/jpg "access 1 year"
ExpiresByType image/jpeg "access 1 year"
ExpiresByType image/gif "access 1 year"
ExpiresByType image/png "access 1 year"
ExpiresByType text/css "access 1 month"
ExpiresByType application/pdf "access 1 month"
ExpiresByType application/javascript "access 1 month"
ExpiresByType application/x-javascript "access 1 month"
ExpiresByType application/x-shockwave-flash "access 1 month"
ExpiresByType image/x-icon "access 1 year"
ExpiresDefault "access 2 days"
</IfModule>
## EXPIRES CACHING ##

RewriteEngine On 
RewriteCond %{HTTPS} !=on 
RewriteRule ^ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=302]
Header always set Content-Security-Policy: upgrade-insecure-requests
