function applyLanguage(lang) {
    fetch(`lang/${lang}.json`)
        .then(response => response.json())
        .then(data => {
            // Function to get the nested value from a dot-notated string (like 'Home.Hello')
            function getNestedValue(obj, key) {
                return key.split('.').reduce((o, i) => o ? o[i] : null, obj);
            }

            // Update text content for elements with specific IDs
            document.querySelectorAll('[id]').forEach(element => {
                const key = element.id;

                // Get the translation value
                const value = getNestedValue(data, key);

                // Only update if the value exists and is a string
                if (typeof value === 'string') {
                    if (element.id === 'search') {
                        // Special handling for the search input
                        element.setAttribute('placeholder', value);
                    } else if (element.id !== 'carouselExampleIndicators') {
                        // Update text content for elements other than carousel
                        element.textContent = value;
                    }
                }
            });

            // Save language preference in localStorage
            localStorage.setItem('lang', lang);

            // Update the lang attribute of the <html> tag
            document.documentElement.setAttribute('lang', lang);

            updateLanguageButtons();
        });
}

function updateLanguageButtons() {
    const currentLang = localStorage.getItem('lang') || 'en';

    if (currentLang === 'en') {
        document.getElementById('btn-en').style.display = "none";
        document.getElementById('btn-ar').style.display = "inline-block";
    } else {
        document.getElementById('btn-en').style.display = "inline-block";
        document.getElementById('btn-ar').style.display = "none";
    }
}

function setLanguage(lang) {
    localStorage.setItem('selectedLanguage', lang);
    applyLanguage(lang);  // Function to change language content on the page
}

function validateCaptcha() {
	var valid = true;	
	
	var v = grecaptcha.getResponse(widgetId);
    if(v.length == 0)
    {
        document.getElementById('captcha').innerHTML="You can't leave Captcha Code empty";
        valid=false;
    }
	else {
		document.getElementById('captcha').innerHTML="";
	}
	if(v.length > 0 && valid== false) {
		grecaptcha.reset();
		 document.getElementById('captcha').innerHTML="";
	}
	return valid;
}

function loadContent(page, element, targetSection = null) {
    
    const contentDiv = document.getElementById('content');

    // Check if we're already on the correct page
    const currentPage = window.location.hash.slice(2); // Remove "/#" from the hash
    const isSamePage = currentPage === page;

    // If we're on the same page and a target section is specified, just scroll
    if (isSamePage && targetSection) {
        scrollToSection(targetSection);
        return;
    }

    // Fetch the HTML content for the clicked page
    fetch(`pages/${page}.html`)
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.text();
        })
        .then(html => {
            // Insert the loaded content into the content div
            contentDiv.innerHTML = html;

            // Apply the selected language if any
            const selectedLanguage = localStorage.getItem('selectedLanguage') || 'en'; // Default to 'en'
            applyLanguage(selectedLanguage);

            // Active link logic: Remove 'active' class from all links
            const links = document.querySelectorAll('.navigation-menu span');
            links.forEach(link => link.classList.remove('active'));

            // Add 'active' class to the clicked link
            if (element) {
                element.classList.add('active');
            } else {
                // Find the menu item based on the page and add 'active' class
                const activeLink = document.querySelector(`.navigation-menu span[data-page="${page}"]`);
                if (activeLink) {
                    activeLink.classList.add('active');
                }
            }

            //window.location.hash = `/${page}`;
            // if (page === "home") {
            //     window.location.hash = "/";
            // } else {
            //     window.location.hash = `/${page}`;
            // }

            if (page === "home") {
                // Update the URL without hash
                history.pushState(null, '', '/');
            } else {
                window.location.hash = `/${page}`;
            }

            // If a target section is specified, scroll to it
            if (targetSection) {
                scrollToSection(targetSection);
            } else {
                // If no target section, scroll to top
                window.scrollTo(0, 0);
            }
            
            const captchaElement = document.getElementById('rcaptcha');
            if (captchaElement) {
                onloadCallback(); // Render the reCAPTCHA widget after content is loaded
            }

             // If an email form is loaded, bind form submission
            const emailForm = document.getElementById('emailForm');
          
             if (emailForm) {
                    // Attach submit event to form
                    emailForm.addEventListener('submit', function (e) {
                        e.preventDefault(); // Prevent default form submission
                        
                        // Call function to handle email submission via AJAX
                        console.log("emailForm => ", emailForm);
                        submitEmailForm(emailForm);
                    });
                
            }

        })
        .catch(error => {
            // Show an error message if content fails to load
            contentDiv.innerHTML = '<div>Error loading content. Please try again later.</div>';
            console.error('Error loading content:', error);
        });

        closeResponsiveMenu();
}


function onloadCallback() {
    console.log("onloadCallback called");  
    if (typeof grecaptcha === 'undefined') {
        console.error("grecaptcha is not loaded");
        return;
    }
    
    if (document.getElementById('rcaptcha')) {
        widgetId = grecaptcha.render('rcaptcha', {
            'sitekey': '6Ld5lncqAAAAAOFom76Az6EUVQ7u2anmtcm89B5_'
        });
    }
}


// Function to validate the email and CAPTCHA
function validateContact(email) {
    let valid = true;
    const captchaResponse = grecaptcha.getResponse();

    // Validate email field
    if (email === "") {
        document.getElementById("email").focus();
        toggleResult("Email is required.", "error");
        valid = false;
    } else if (!email.match(/^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/)) {
        toggleResult("Invalid email address.", "error");
        valid = false;
    } else {
        toggleResult();
    }

    // Validate CAPTCHA response
    if (captchaResponse.length === 0) {
        document.getElementById('captcha').innerHTML = "Please complete the CAPTCHA.";
        valid = false;
    } else {
        document.getElementById('captcha').innerHTML = ""; // Clear any previous CAPTCHA error
    }

    return valid;
}

function toggleResult(message = "", type = "") {
    const resultElement = document.getElementById('result');
    if (message) {
        resultElement.textContent = message;
        if(type==="error"){
            $('#result').removeClass('success').addClass('error');
        }else{
            $('#result').removeClass('error').addClass('success');
        }
        resultElement.style.display = 'block';
        // document.getElementById('submitbtn').style.marginBottom = '37px';
    } else {
        resultElement.style.display = 'none'; // Hide the element
        // document.getElementById('submitbtn').style.marginBottom = '0';
    }
}

// Function to handle the email form submission via AJAX
function submitEmailForm(emailForm) {
    const formData = new FormData(emailForm);
    const email = formData.get('email');
    const phone = formData.get('phone');
    const text = formData.get('Text');

    const isFormValid = validateContact(email);

    if (!isFormValid) {
        return false; // Stop form submission if validation fails
    }

    // Proceed with AJAX form submission if validation is successful
    $.ajax({
        url: 'pages/send_email.php', // URL to the PHP file
        type: 'POST',
        data: {
            email: email,// Send only the email field
            phone: phone,
            text: text
        },
        success: function(result) {
            // Display the success message returned from PHP
            toggleResult(result, "success");
            emailForm.reset(); // Reset form fields
            grecaptcha.reset(); // Reset reCAPTCHA

            setTimeout(function() {
                document.getElementById('submitbtn').style.marginBottom = '0';
                $('#result').fadeOut(); // Fade out the result message after 60 seconds
            }, 60000);
        },
        error: function(xhr, status, error) {
            // Handle any error returned by the server
            toggleResult('There was an error sending the email.', "error");
            console.error('Error sending email:', error);
        }
    });

    return false; // Prevent default form submission behavior
}


function scrollToSection(sectionId) {
    setTimeout(() => {
        const targetElement = document.getElementById(sectionId);
        if (targetElement) {
            targetElement.scrollIntoView({ behavior: 'smooth', block: 'start' });
        } else {
            console.warn(`Element with id "${sectionId}" not found in the loaded content.`);
        }
    }, 100); // Small delay to ensure content is loaded
}

window.onload = function() {
  const selectedLanguage = localStorage.getItem('selectedLanguage') || 'en';  // Load the saved language or default to 'en'
  applyLanguage(selectedLanguage);  // Apply language on page load
 // updateLanguageButtons();
  const hash = window.location.hash.substring(2); // Remove the '#' from the hash
  const selectedPage = hash ? hash : 'home';
  loadContent(selectedPage);  // Load the default content
};

function handleHashOrPopState() {
    const hash = window.location.hash.substring(2); // Remove the '#' from the hash
    const selectedPage = hash ? hash : 'home'; 
    loadContent(selectedPage);  // Load the new content based on the hash
}

function closeResponsiveMenu() {
    var nav = document.querySelector('ul.topnav');
    if (nav.classList.contains('responsive')) {
      nav.classList.remove('responsive');
    }
  }

// Add event listeners for both 'hashchange' and 'popstate'
window.addEventListener('hashchange', handleHashOrPopState);
window.addEventListener('popstate', handleHashOrPopState);