    // Clear checkbox error message
    function clearError() {
        var checkboxContainer = document.getElementById('checkboxContainer');
        var errorMessage = document.getElementById('checkboxError');
        if (checkboxContainer && errorMessage) {
            checkboxContainer.classList.remove('error');
            errorMessage.style.display = 'none';
        }
        updateSubmitButton(); // Update submit button state when error is cleared
    }

    // Show checkbox error message
    function showError() {
        var checkboxContainer = document.getElementById('checkboxContainer');
        var errorMessage = document.getElementById('checkboxError');
        if (checkboxContainer && errorMessage) {
            checkboxContainer.classList.add('error');
            errorMessage.style.display = 'block';
        }
    }

    // Clear CAPTCHA error message
    function clearCaptchaError() {
        var captchaContainer = document.getElementById('captcha');
        if (captchaContainer) {
            captchaContainer.innerHTML = '';
            captchaContainer.classList.remove('error');
        }
    }

    // Show CAPTCHA error message
    function showCaptchaError() {
        var captchaContainer = document.getElementById('captcha');
        if (captchaContainer) {
            captchaContainer.innerHTML = '<div class="error-message" style="display: block;">Please complete the CAPTCHA verification.</div>';
            captchaContainer.classList.add('error');
        }
    }

    // Validate form submission
    function validateForm() {
        var isValid = true;

        // Check CAPTCHA (only if grecaptcha is available)
        if (typeof grecaptcha !== 'undefined') {
            try {
                var captchaResponse = grecaptcha.getResponse();
                if (!captchaResponse || captchaResponse.length === 0) {
                    showCaptchaError();
                    isValid = false;
                } else {
                    clearCaptchaError();
                }
            } catch (error) {
                console.warn('CAPTCHA validation error:', error);
                showCaptchaError();
                isValid = false;
            }
        } else {
            // If grecaptcha is not available, show error
            showCaptchaError();
            isValid = false;
        }

        // Check checkbox
        var checkbox = document.getElementById('agreementCheckbox');
        if (!checkbox) {
            return false; // If checkbox element not found, prevent submission
        }

        if (!checkbox.checked) {
            showError(); // Show error message if checkbox is not checked
            isValid = false;
        } else {
            clearError(); // Clear error if checkbox is checked
        }

        // Scroll to first error if validation fails
        if (!isValid) {
            // Check CAPTCHA first
            var captchaFailed = false;
            if (typeof grecaptcha !== 'undefined') {
                try {
                    var captchaResponse = grecaptcha.getResponse();
                    captchaFailed = !captchaResponse || captchaResponse.length === 0;
                } catch (error) {
                    captchaFailed = true;
                }
            } else {
                captchaFailed = true;
            }

            if (captchaFailed) {
                var captchaContainer = document.getElementById('rcaptcha');
                if (captchaContainer) {
                    captchaContainer.scrollIntoView({ behavior: 'smooth', block: 'center' });
                }
            } else if (!checkbox.checked) {
                var container = document.getElementById('checkboxContainer');
                if (container) {
                    container.scrollIntoView({ behavior: 'smooth', block: 'center' });
                }
            }
        }

        return isValid; // Allow form submission only if both CAPTCHA and checkbox are valid
    }

  function updateSubmitButton() {
    var checkbox = document.getElementById('agreementCheckbox');
    var submitButton = document.getElementById('submitbtn');
    var email = document.getElementById('email');
    var phone = document.getElementById('phone');
    var text = document.getElementById('Text');

    var allFilled =
      email.value.trim() !== '' &&
      phone.value.trim() !== '' &&
      text.value.trim() !== '' &&
      checkbox.checked;

    submitButton.disabled = !allFilled;
    submitButton.classList.toggle('disabled', !allFilled);
  }



function applyLanguage(lang) {
    fetch(`lang/${lang}.json`)
        .then(response => response.json())
        .then(data => {
            // Function to get the nested value from a dot-notated string (like 'Home.Hello')
            function getNestedValue(obj, key) {
                return key.split('.').reduce((o, i) => o ? o[i] : null, obj);
            }

            // Update text content for elements with specific IDs
            document.querySelectorAll('[id]').forEach(element => {
                const key = element.id;

                // Get the translation value
                const value = getNestedValue(data, key);

                // Only update if the value exists and is a string
                if (typeof value === 'string') {
                    if (element.id === 'search') {
                        // Special handling for the search input
                        element.setAttribute('placeholder', value);
                    } else if (element.id !== 'carouselExampleIndicators') {
                        // Update text content for elements other than carousel
                        element.textContent = value;
                    }
                }
            });

            // Save language preference in localStorage
            localStorage.setItem('lang', lang);

            // Update the lang attribute of the <html> tag
            document.documentElement.setAttribute('lang', lang);

            updateLanguageButtons();
        });
}

function updateLanguageButtons() {
    const currentLang = localStorage.getItem('lang') || 'en';

    if (currentLang === 'en') {
        document.getElementById('btn-en').style.display = "none";
        document.getElementById('btn-ar').style.display = "inline-block";
    } else {
        document.getElementById('btn-en').style.display = "inline-block";
        document.getElementById('btn-ar').style.display = "none";
    }
}

function setLanguage(lang) {
    localStorage.setItem('selectedLanguage', lang);
    applyLanguage(lang);  // Function to change language content on the page
}

function validateCaptcha() {
	var valid = true;	
	
	var v = grecaptcha.getResponse(widgetId);
    if(v.length == 0)
    {
        document.getElementById('captcha').innerHTML="You can't leave Captcha Code empty";
        valid=false;
    }
	else {
		document.getElementById('captcha').innerHTML="";
	}
	if(v.length > 0 && valid== false) {
		grecaptcha.reset();
		 document.getElementById('captcha').innerHTML="";
	}
	return valid;
}

function loadContent(page, element, targetSection = null) {
    
    const contentDiv = document.getElementById('content');

    // Check if we're already on the correct page
    const currentPage = window.location.hash.slice(2); // Remove "/#" from the hash
    const isSamePage = currentPage === page;

    // If we're on the same page and a target section is specified, just scroll
    if (isSamePage && targetSection) {
        scrollToSection(targetSection);
        return;
    }

    // Fetch the HTML content for the clicked page
    fetch(`pages/${page}.html`)
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.text();
        })
        .then(html => {
            // Insert the loaded content into the content div
            contentDiv.innerHTML = html;

            // Apply the selected language if any
            const selectedLanguage = localStorage.getItem('selectedLanguage') || 'en'; // Default to 'en'
            applyLanguage(selectedLanguage);

            // Active link logic: Remove 'active' class from all links
            const links = document.querySelectorAll('.navigation-menu span');
            links.forEach(link => link.classList.remove('active'));

            // Add 'active' class to the clicked link
            if (element) {
                element.classList.add('active');
            } else {
                // Find the menu item based on the page and add 'active' class
                const activeLink = document.querySelector(`.navigation-menu span[data-page="${page}"]`);
                if (activeLink) {
                    activeLink.classList.add('active');
                }
            }

            //window.location.hash = `/${page}`;
            // if (page === "home") {
            //     window.location.hash = "/";
            // } else {
            //     window.location.hash = `/${page}`;
            // }

            if (page === "home") {
                // Update the URL without hash
                history.pushState(null, '', '/');
            } else {
                window.location.hash = `/${page}`;
            }

            // If a target section is specified, scroll to it
            if (targetSection) {
                scrollToSection(targetSection);
            } else {
                // If no target section, scroll to top
                window.scrollTo(0, 0);
            }
            
            const captchaElement = document.getElementById('rcaptcha');
            if (captchaElement) {
                onloadCallback(); // Render the reCAPTCHA widget after content is loaded
            }

             // If an email form is loaded, bind form submission
            const emailForm = document.getElementById('emailForm');
          
             if (emailForm) {
                    // Attach submit event to form
                    emailForm.addEventListener('submit', function (e) {
                        e.preventDefault(); // Prevent default form submission
                        
                        // Call function to handle email submission via AJAX
                        console.log("emailForm => ", emailForm);
                        submitEmailForm(emailForm);
                    });
                
            }

            const email = document.getElementById('email');
            const phone = document.getElementById('phone');
            const text = document.getElementById('Text');
            const checkbox = document.getElementById('agreementCheckbox');

            if(email || phone || text || checkbox){
                // Bind updateSubmitButton to input fields and checkbox after dynamic load
                [email, phone, text].forEach(field => {
                    if (field) {
                        field.addEventListener('input', updateSubmitButton);
                        field.addEventListener('change', updateSubmitButton);
                    }
                });

                if (checkbox) {
                    checkbox.addEventListener('change', updateSubmitButton);
                }

                // Initialize button state
                updateSubmitButton();
            }
        })
        .catch(error => {
            // Show an error message if content fails to load
            contentDiv.innerHTML = '<div>Error loading content. Please try again later.</div>';
            console.error('Error loading content:', error);
        });

        closeResponsiveMenu();
}


function onloadCallback() {
    console.log("onloadCallback called");  
    if (typeof grecaptcha === 'undefined') {
        console.error("grecaptcha is not loaded");
        return;
    }
    
    if (document.getElementById('rcaptcha')) {
        widgetId = grecaptcha.render('rcaptcha', {
            'sitekey': '6Ld5lncqAAAAAOFom76Az6EUVQ7u2anmtcm89B5_'
        });
    }
}


// Function to validate the email and CAPTCHA
function validateContact(email) {
    let valid = true;
    const captchaResponse = grecaptcha.getResponse();

    // Validate email field
    if (email === "") {
        document.getElementById("email").focus();
        toggleResult("Email is required.", "error");
        valid = false;
    } else if (!email.match(/^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/)) {
        toggleResult("Invalid email address.", "error");
        valid = false;
    } else {
        toggleResult();
    }

    // Validate CAPTCHA response
    if (captchaResponse.length === 0) {
        document.getElementById('captcha').innerHTML = "Please complete the CAPTCHA.";
        valid = false;
    } else {
        document.getElementById('captcha').innerHTML = ""; // Clear any previous CAPTCHA error
    }

    return valid;
}

function toggleResult(message = "", type = "") {
    const resultElement = document.getElementById('result');
    if (message) {
        resultElement.textContent = message;
        if(type==="error"){
            $('#result').removeClass('success').addClass('error');
        }else{
            $('#result').removeClass('error').addClass('success');
        }
        resultElement.style.display = 'block';
        // document.getElementById('submitbtn').style.marginBottom = '37px';
    } else {
        resultElement.style.display = 'none'; // Hide the element
        // document.getElementById('submitbtn').style.marginBottom = '0';
    }
}

// Function to handle the email form submission via AJAX
function submitEmailForm(emailForm) {
    const formData = new FormData(emailForm);
    const email = formData.get('email');
    const phone = formData.get('phone');
    const text = formData.get('Text');

    const isFormValid = validateContact(email);

    if (!isFormValid) {
        return false; // Stop form submission if validation fails
    }

    // Proceed with AJAX form submission if validation is successful
    $.ajax({
        url: 'pages/send_email.php', // URL to the PHP file
        type: 'POST',
        data: {
            email: email,// Send only the email field
            phone: phone,
            text: text
        },
        success: function(result) {
            // Display the success message returned from PHP
            toggleResult(result, "success");
            emailForm.reset(); // Reset form fields
            grecaptcha.reset(); // Reset reCAPTCHA

            setTimeout(function() {
                document.getElementById('submitbtn').style.marginBottom = '0';
                $('#result').fadeOut(); // Fade out the result message after 60 seconds
            }, 60000);
        },
        error: function(xhr, status, error) {
            // Handle any error returned by the server
            toggleResult('There was an error sending the email.', "error");
            console.error('Error sending email:', error);
        }
    });

    return false; // Prevent default form submission behavior
}


function scrollToSection(sectionId) {
    setTimeout(() => {
        const targetElement = document.getElementById(sectionId);
        if (targetElement) {
            targetElement.scrollIntoView({ behavior: 'smooth', block: 'start' });
        } else {
            console.warn(`Element with id "${sectionId}" not found in the loaded content.`);
        }
    }, 100); // Small delay to ensure content is loaded
}

window.onload = function() {
  const selectedLanguage = localStorage.getItem('selectedLanguage') || 'en';  // Load the saved language or default to 'en'
  applyLanguage(selectedLanguage);  // Apply language on page load
 // updateLanguageButtons();
  const hash = window.location.hash.substring(2); // Remove the '#' from the hash
  const selectedPage = hash ? hash : 'home';
  loadContent(selectedPage);  // Load the default content
};

function handleHashOrPopState() {
    const hash = window.location.hash.substring(2); // Remove the '#' from the hash
    const selectedPage = hash ? hash : 'home'; 
    loadContent(selectedPage);  // Load the new content based on the hash
}

function closeResponsiveMenu() {
    var nav = document.querySelector('ul.topnav');
    if (nav.classList.contains('responsive')) {
      nav.classList.remove('responsive');
    }
  }

// Add event listeners for both 'hashchange' and 'popstate'
window.addEventListener('hashchange', handleHashOrPopState);
window.addEventListener('popstate', handleHashOrPopState);