<?php

// File generated from our OpenAPI spec
namespace WPForms\Vendor\Stripe\Events;

/**
 * @property \Stripe\RelatedObject $related_object Object containing the reference to API resource relevant to the event
 * @property \Stripe\EventData\V1BillingMeterErrorReportTriggeredEventData $data data associated with the event
 */
class V1BillingMeterErrorReportTriggeredEvent extends \WPForms\Vendor\Stripe\V2\Event
{
    const LOOKUP_TYPE = 'v1.billing.meter.error_report_triggered';
    /**
     * Retrieves the related object from the API. Make an API request on every call.
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \Stripe\Billing\Meter
     */
    public function fetchRelatedObject()
    {
        $apiMode = \WPForms\Vendor\Stripe\Util\Util::getApiMode($this->related_object->url);
        list($object, $options) = $this->_request('get', $this->related_object->url, [], ['stripe_account' => $this->context], [], $apiMode);
        return \WPForms\Vendor\Stripe\Util\Util::convertToStripeObject($object, $options, $apiMode);
    }
    public static function constructFrom($values, $opts = null, $apiMode = 'v2')
    {
        $evt = parent::constructFrom($values, $opts, $apiMode);
        if (null !== $evt->data) {
            $evt->data = \WPForms\Vendor\Stripe\EventData\V1BillingMeterErrorReportTriggeredEventData::constructFrom($evt->data, $opts, $apiMode);
        }
        return $evt;
    }
}
